# CLIPFUSION

Official Implementation of CLIP Meets Diffusion: A Synergistic Approach to Anomaly Detection

## Environment

Ubuntu 22.04.4 LTS, CUDA 12.4

## Installation

```bash
conda create -n clipfusion python==3.12.8
conda activate clipfusion
pip install -r requirements.txt
```

## Running Tests

To run tests, run the following command

```bash
bash cls_mvtec.sh   # MVTec-AD Classification
bash seg_mvtec.sh   # MVTec-AD Segmentation
bash cls_visa.sh    # VisA Classification
bash seg_visa.sh    # VisA Classification
```

For all bash files, default setting is 0-shot inference. To use the few-shot setting, change the ZERO_SHOT variable to `false` for running of 1,2,4-shot CLIPFUSION.

## Data

Download the MVTec-AD dataset from [here](https://www.mvtec.com/company/research/datasets/mvtec-ad)

Download the VisA dataset from [here](https://amazon-visual-anomaly.s3.us-west-2.amazonaws.com/VisA_20220922.tar)

In each bash file, modify the `DATA_PATH` variable to corresponding data folder. For both datasets, data folder configuration is assumed to be as follows:
```bash
DATA_PATH/
    object_1/
        ground_truth/
            defect_class_1/
            ...
        test/
            good/
            defect_class_1/
            ...
        train/
            good/
    ...
```

To preprocess the VisA to the configuration above, follow the official splitting code from [here](https://github.com/amazon-science/spot-diff?tab=readme-ov-file#data-preparation)
